/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Structures;

import BryceMath.Numbers.Number;
import BryceMath.Numbers.Rational;
import BryceMath.Structures.Matrix;
import BryceMath.Structures.Vector;
import Data_Structures.Structures.UBA;
import util.Genarics;

public class Polynomial {
    private UBA<Rational> data;

    public Polynomial(int ... input) {
        int len = input.length;
        this.data = new UBA(len);
        boolean leading_coef_found = false;
        int[] nArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (!leading_coef_found && i != 0) {
                leading_coef_found = true;
            }
            if (leading_coef_found) {
                this.data.add(new Rational(i));
            }
            ++n2;
        }
    }

    public Polynomial(Rational ... input) {
        this.ivars(input);
    }

    public Polynomial(Vector<Rational> ... input) {
        int len = input.length;
        Genarics<Vector<Rational>> ge_v = new Genarics<Vector<Rational>>();
        Vector<Rational>[] rows = ge_v.Array(len, input[0]);
        int r = 0;
        while (r < len) {
            Number[] row_new = new Rational[len];
            assert (input[r].length == 2);
            Rational x = input[r].get(0);
            int c = 0;
            while (c < len) {
                row_new[c] = (Rational)x.pow(len - 1 - c);
                ++c;
            }
            rows[r] = new Vector(row_new);
            ++r;
        }
        Matrix<Rational> A = new Matrix<Rational>(rows);
        Number[] col = new Rational[len];
        int i = 0;
        while (i < len) {
            col[i] = input[i].get(1);
            ++i;
        }
        Vector b = new Vector(col);
        Vector<Rational> result = A.solve(b);
        this.ivars((Rational[])result.toArray());
    }

    private void ivars(Rational ... input) {
        int len = input.length;
        this.data = new UBA(len);
        boolean leading_coef_found = false;
        Rational[] rationalArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            Rational r = rationalArray[n2];
            if (r == null) {
                r = new Rational(0L);
            }
            if (!leading_coef_found && !r.eq(0)) {
                leading_coef_found = true;
            }
            if (leading_coef_found) {
                this.data.add(r);
            }
            ++n2;
        }
    }

    public Polynomial add(Polynomial other) {
        int end_degree = Math.max(this.get_degree(), other.get_degree());
        Rational[] output = new Rational[end_degree + 1];
        int i = 0;
        while (i <= end_degree) {
            output[end_degree - i] = this.get_coef(i).add(other.get_coef(i));
            ++i;
        }
        return new Polynomial(output);
    }

    public Polynomial sub(Polynomial other) {
        int end_degree = Math.max(this.get_degree(), other.get_degree());
        Rational[] output = new Rational[end_degree + 1];
        int i = 0;
        while (i <= end_degree) {
            output[end_degree - i] = this.get_coef(i).sub(other.get_coef(i));
            ++i;
        }
        return new Polynomial(output);
    }

    public Polynomial mult(Polynomial other) {
        Polynomial p2;
        Polynomial p1;
        int min_passes;
        int end_degree = this.get_degree() + other.get_degree();
        if (this.get_degree() < other.get_degree()) {
            min_passes = this.get_degree() + 1;
            p1 = this;
            p2 = other;
        } else {
            min_passes = other.get_degree() + 1;
            p1 = other;
            p2 = this;
        }
        Polynomial output = new Polynomial(0);
        int r = 0;
        while (r < min_passes) {
            Rational coef1 = p1.get_coef(r);
            Rational[] temp = new Rational[end_degree + 1];
            int c = 0;
            while (c < other.get_degree() + 1) {
                Rational coef2 = p2.get_coef(c);
                temp[end_degree - (c + r)] = coef1.mult(coef2);
                ++c;
            }
            output = output.add(new Polynomial(temp));
            ++r;
        }
        return output;
    }

    public Polynomial der() {
        Polynomial output = this.clone();
        UBA<Rational> data = output.data;
        int i = 0;
        while (i < this.get_degree()) {
            data.set(i, (Rational)data.get(i).mult(this.get_degree() - i));
            ++i;
        }
        data.rem();
        return output;
    }

    public Polynomial der(int der_num) {
        Polynomial output = this.der();
        int i = 1;
        while (i < der_num) {
            output = output.der();
            ++i;
        }
        return output;
    }

    public Polynomial integrate() {
        Polynomial output = this.clone();
        UBA<Rational> data = output.data;
        int i = 0;
        while (i < this.get_degree()) {
            data.set(i, (Rational)data.get(i).div(this.get_degree() - i + 1));
            ++i;
        }
        data.add(new Rational(0L));
        return output;
    }

    public Rational get_coef(int power) {
        int size = this.data.size();
        if (power >= size) {
            return new Rational(0L);
        }
        return this.data.get(size - power - 1);
    }

    public int get_degree() {
        return this.data.size() - 1;
    }

    public void setCoef(int power, Rational input) {
        this.data.set(this.data.size() - power - 1, input);
    }

    public Rational eval(Rational x) {
        Rational output = this.get_coef(0);
        int deg = this.get_degree();
        Rational x_current = x.one();
        int i = 1;
        while (i <= deg) {
            x_current = x_current.mult(x);
            output = output.add(this.get_coef(i).mult(x_current));
            ++i;
        }
        return output;
    }

    public Rational eval(int x) {
        return this.eval(new Rational(x));
    }

    public String toString() {
        int len;
        String output = "";
        int i = len = this.get_degree();
        while (i >= 0) {
            if (i == 0) {
                output = String.valueOf(output) + this.get_coef(0);
                break;
            }
            if (!this.get_coef(i).eq(new Rational(0L))) {
                if (!this.get_coef(i).eq(new Rational(1L))) {
                    output = String.valueOf(output) + this.get_coef(i);
                }
                if (i > 0) {
                    output = String.valueOf(output) + "X";
                }
                if (i > 1) {
                    output = String.valueOf(output) + "^" + i;
                }
                if (i > 0) {
                    output = String.valueOf(output) + " + ";
                }
            }
            --i;
        }
        return output;
    }

    public Polynomial clone() {
        Rational[] temp = (Rational[])this.data.toArray();
        return new Polynomial(temp);
    }

    public static Polynomial zero() {
        return new Polynomial(0);
    }
}

